% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/built.index.R
\name{built.index}
\alias{built.index}
\title{built index}
\usage{
built.index(
  green,
  red,
  nir,
  swir1,
  swir2,
  L = 0.5,
  method = c("Bouhennache", "Zha", "Xu")
)
}
\arguments{
\item{green}{Green band (0.53 - 0.59mm), landsat 5&7 band 3, OLI
(landsat 8) band 3}

\item{red}{Red band (0.636 - 0.673mm), landsat 5&7 band 3, OLI
(landsat 8) band 4}

\item{nir}{Near infrared band (0.851 - 0.879mm) landsat 5&7 band 4,
OLI (landsat 8) band 5}

\item{swir1}{short-wave infrared band 1 (1.566 - 1.651mm), landsat 5&7
band 5, OLI (landsat 8) band 6}

\item{swir2}{short-wave infrared band 2 (2.11 - 2.29mm), landsat 5&7
band 7, OLI (landsat 8) band 7}

\item{L}{The L factor for the savi index}

\item{method}{Method to use for index options are "Bouhennache", "Zha", "Xu"}
}
\value{
A terra raster object of the built index
}
\description{
Remote sensing built-up index
}
\details{
This function calculates the built-up index. Three methods are available:
\itemize{
\item Bouhennache is a new method that uses a larger portion of the VIR/NIR
following OLI bands (((b3+b4+b7)-b6)/3) / (((b3+b4+b7)+b6)/3)
\item Zha is the original band ratio method using TM5 ndbi = (b5 - b4) / (b5 + b4)
\item Xu is a modification to eliminate noise using ETM+7
(ndbi-((savi-nndwi)/2) / (ndbi+((savi-nndwi)/2)
}

Generally water has the highest values where built-up areas will occur in the
mid portion of the distribution. Since Bouhennache et al (2018) index exploits
a larger portion of the visible (Vis) and infra red spectrum, vegetation will
occur as the  lowest values and barren will exhibit greater values than the
vegetation and lower values than the built-up areas.

Band wavelength (nanometers) designations for landsat
TM4, TM5 and ETM+7
\itemize{
\item band-2 0.52-0.60 (green)
\item band-3 0.63-0.69 (red)
\item band-4 0.76-0.90 (NIR)
\item band-5 1.55-1.75 (SWIR 1)
\item band-7 2.09-2.35 (SWIR 2)
}

OLI (Landsat 8)
\itemize{
\item band-3 0.53-0.59 (green)
\item band-4 0.64-0.67 (red)
\item band-5 0.85-0.88 (NIR)
\item band-6 1.57-1.65 (SWIR 1)
\item band-7 2.11-2.29 (SWIR 2)
}
}
\examples{
\donttest{
library(terra)
 lsat <- rast(system.file("/extdata/Landsat_TM5.tif", package="spatialEco"))
   plotRGB(lsat, r=3, g=2, b=1, scale=1.0, stretch="lin")
			   
 # Using Bouhennache et al., (2018) method (needs green, red, swir1 and swir2) 
 ( bouh <- built.index(red = lsat[[3]], green = lsat[[2]], swir1 = lsat[[5]], 
                      swir2 = lsat[[6]]) )
    plotRGB(lsat, r=3, g=2, b=1, scale=1, stretch="lin")
      plot(bouh, legend=FALSE, col=rev(terrain.colors(100, alpha=0.35)), 
	       add=TRUE )

 # Using simple Zha et al., (2003) method (needs nir and swir1)
 ( zha <- built.index(nir = lsat[[4]], swir1 = lsat[[5]], method = "Zha") )
   plotRGB(lsat, r=3, g=2, b=1, scale=1, stretch="lin")
     plot(zha, legend=FALSE, col=rev(terrain.colors(100, alpha=0.35)), add=TRUE )

 # Using Xu (2008) normalized modification of Zha (needs green, red, nir and swir1)
 ( xu <- built.index(green= lsat[[2]], red = lsat[[3]], nir = lsat[[4]], 
                     swir1 = lsat[[5]], , method = "Xu") )
   plotRGB(lsat, r=3, g=2, b=1, scale=1, stretch="lin")
     plot(xu, legend=FALSE, col=rev(terrain.colors(100, alpha=0.35)), add=TRUE ) 
}

}
\references{
Bouhennache, R., T. Bouden, A. Taleb-Ahmed & A. Chaddad(2018) A new spectral index
for the extraction of built-up land features from Landsat 8 satellite imagery,
Geocarto International 34(14):1531-1551

Xu H. (2008) A new index for delineating built-up land features in satellite imagery.
International Journal Remote Sensing 29(14):4269-4276.

Zha G.Y., J. Gao, & S. Ni (2003) Use of normalized difference built-up index in
automatically mapping urban areas from TM imagery. International Journal of
Remote Sensing 24(3):583-594
}
\author{
Jeffrey S. Evans  \href{mailto:jeffrey_evans@tnc.org}{jeffrey_evans@tnc.org}
}
