% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.loess.R
\name{impute.loess}
\alias{impute.loess}
\title{Impute loess}
\usage{
impute.loess(y, s = 0.2, smooth = FALSE)
}
\arguments{
\item{y}{A vector to impute}

\item{s}{Smoothing parameter ()}

\item{smooth}{(FALSE/TRUE) Smooth data, else only replace NA's}
}
\value{
A vector the same length as x with NA values filled or the data smoothed (or both).
}
\description{
Imputes missing data or smooths using Loess regression
}
\details{
Performs a local polynomial regression to smooth data or to 
impute NA values. The minimal number of non-NA observations to reliably
impute/smooth values is 6. There is not a reliably way to impute NA's
on the tails of the distributions so if the missing data is in the
first or last position of the vector it will remain NA. Please note
that smooth needs to be TRUE to return a smoothed vector, else only
NA's will be imputed.
}
\examples{
data(cor.data)
d <- cor.data[[1]][,2]
  plot(d, type="l")
  lines(impute.loess(d, s=0.3, smooth=TRUE), lwd=2, col="red")
 
# add some NA's
d <- d[1:100]
  d[sample(30:70, 5)] <- NA 
  d
  
impute.loess(d, s=0.2)
  
}
\author{
Jeffrey S. Evans  <jeffrey_evans<at>tnc.org>
}
