% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.vol.R
\name{raster.vol}
\alias{raster.vol}
\title{Raster Percent Volume}
\usage{
raster.vol(
  x,
  p = 0.75,
  sample = FALSE,
  spct = 0.05,
  type = c("random", "regular")
)
}
\arguments{
\item{x}{A terra SpatRaster class object}

\item{p}{percent raster-value volume}

\item{sample}{(FALSE/TRUE) base volume on systematic point sample}

\item{spct}{sample percent, if sample (TRUE)}

\item{type}{If sample=TRUE type of sample, options are "random" or "regular"}
}
\value{
if sample (FALSE) binary raster object with 1 representing designated 
percent volume else, if sample (TRUE) n sf POINT object with points 
that represent the percent volume of the sub-sample
}
\description{
Calculates a percent volume on a raster or based on a 
             systematic sample
}
\note{
Since this model needs to operate on all of the raster values, it is not memory safe
}
\examples{
\donttest{
library(terra)
  r <- rast(ncols=100, nrows=100)
    r[] <- runif(ncell(r), 0, 1)
    r <- focal(r, w=focalMat(r, 6, "Gauss"))
  #r[sample(1:ncell(r)),10] <- NA
  
  # full raster percent volume 
  p30 <- raster.vol(r, p=0.30)
  p50 <- raster.vol(r, p=0.50)
  p80 <- raster.vol(r, p=0.80)

opar <- par(no.readonly=TRUE)
    par(mfrow=c(2,2))
    plot(r, col=cm.colors(10), main="original raster")
    plot(p30, breaks=c(0,0.1,1), col=c("cyan","red"), legend=FALSE,
      main="30\% volume")
    plot(p50, breaks=c(0,0.1,1), col=c("cyan","red"), legend=FALSE,
      main="50\% volume")
    plot(p80, breaks=c(0,0.1,1), col=c("cyan","red"), legend=FALSE,
      main="80\% volume")
par(opar)  
}

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
