% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vrm.R
\name{vrm}
\alias{vrm}
\title{Vector Ruggedness Measure (VRM)}
\usage{
vrm(x, s = 3)
}
\arguments{
\item{x}{A terra SpatRaster class object}

\item{s}{Scale of window. Must be odd number, can represent 2 dimensions 
(eg., s=c(3,5) would represent a 3 x 5 window)}
}
\value{
A terra SpatRaster class object of the VRI
}
\description{
Implementation of the Sappington et al., (2007) vector 
             ruggedness measure
}
\details{
This function measures terrain ruggedness by calculating the vector 
ruggedness measure
}
\examples{
library(terra)
elev <- rast(system.file("extdata/elev.tif", package="spatialEco"))
   vrm3 <- vrm(elev) 
   vrm5 <- vrm(elev, s=5)
   plot(c(vrm3, vrm5))

}
\references{
Sappington, J.M., K.M. Longshore, D.B. Thomson (2007). Quantifying Landscape 
  Ruggedness for Animal Habitat Analysis: A case Study Using Bighorn Sheep in 
  the Mojave Desert. Journal of Wildlife Management. 71(5):1419-1426
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
