% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_distance_thresholds.R
\name{default_distance_thresholds}
\alias{default_distance_thresholds}
\title{Default distance thresholds for spatial predictors}
\usage{
default_distance_thresholds(distance.matrix = NULL)
}
\arguments{
\item{distance.matrix}{Numeric distance matrix (typically square and symmetric). Default: \code{NULL}.}
}
\value{
Numeric vector of length 4 with distance thresholds (floored to integers).
}
\description{
Generates four evenly-spaced distance thresholds for spatial predictor generation, ranging from 0 to half the maximum distance in the matrix.
}
\details{
The maximum threshold is set to half the maximum distance to avoid spatial predictors based on distances that are too large to capture meaningful spatial autocorrelation. The four thresholds are evenly spaced using \code{\link[=seq]{seq()}} with \code{length.out = 4}.
}
\examples{
data(plants_distance)

thresholds <- default_distance_thresholds(
  distance.matrix = plants_distance
)

thresholds
# Example output: c(0, 3333, 6666, 10000)
# Four evenly-spaced thresholds from 0 to max(plants_distance)/2

}
\seealso{
Other preprocessing: 
\code{\link{auto_cor}()},
\code{\link{auto_vif}()},
\code{\link{case_weights}()},
\code{\link{double_center_distance_matrix}()},
\code{\link{is_binary}()},
\code{\link{make_spatial_fold}()},
\code{\link{make_spatial_folds}()},
\code{\link{the_feature_engineer}()},
\code{\link{weights_from_distance_matrix}()}
}
\concept{preprocessing}
