% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_residuals.R
\name{get_residuals}
\alias{get_residuals}
\title{Extract model residuals}
\usage{
get_residuals(model)
}
\arguments{
\item{model}{Model object from \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.}
}
\value{
Numeric vector of residuals with length equal to the number of training observations. For \code{\link[=rf_repeat]{rf_repeat()}} models, returns the median residual across repetitions.
}
\description{
Extracts residuals (observed - predicted values) from models fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.
}
\details{
Residuals are calculated as observed minus predicted values. They can be used to assess model fit, check assumptions, and diagnose patterns such as spatial autocorrelation (see \code{\link[=get_moran]{get_moran()}}). Ideally, residuals should be randomly distributed with no systematic patterns.
}
\examples{
data(plants_rf)

# Extract residuals
residuals <- get_residuals(plants_rf)
head(residuals)

# Check basic statistics
summary(residuals)

# Plot distribution to check for patterns
hist(residuals, main = "Residual Distribution", xlab = "Residuals")

}
\seealso{
\code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, \code{\link[=rf_spatial]{rf_spatial()}}, \code{\link[=get_predictions]{get_predictions()}}, \code{\link[=get_moran]{get_moran()}}, \code{\link[=plot_residuals_diagnostics]{plot_residuals_diagnostics()}}

Other model_info: 
\code{\link{get_evaluation}()},
\code{\link{get_importance}()},
\code{\link{get_importance_local}()},
\code{\link{get_moran}()},
\code{\link{get_performance}()},
\code{\link{get_predictions}()},
\code{\link{get_response_curves}()},
\code{\link{get_spatial_predictors}()},
\code{\link{print.rf}()},
\code{\link{print_evaluation}()},
\code{\link{print_importance}()},
\code{\link{print_moran}()},
\code{\link{print_performance}()}
}
\concept{model_info}
