% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_importance_spatial.R
\name{prepare_importance_spatial}
\alias{prepare_importance_spatial}
\title{Prepares variable importance objects for spatial models}
\usage{
prepare_importance_spatial(model)
}
\arguments{
\item{model}{An importance data frame with spatial predictors, or a model fitted with \code{\link[=rf_spatial]{rf_spatial()}}.}
}
\value{
A list with importance data frames in different formats depending on whether the model was fitted with \code{\link[=rf]{rf()}} or \code{\link[=rf_repeat]{rf_repeat()}}.
}
\description{
Prepares variable importance data frames and plots for models fitted with \code{\link[=rf_spatial]{rf_spatial()}}.
}
\examples{

data(plants_rf_spatial)

prepare_importance_spatial(plants_rf_spatial) \%>\%
  head()

}
\seealso{
Other utilities: 
\code{\link{.vif_to_df}()},
\code{\link{auc}()},
\code{\link{beowulf_cluster}()},
\code{\link{objects_size}()},
\code{\link{optimization_function}()},
\code{\link{rescale_vector}()},
\code{\link{root_mean_squared_error}()},
\code{\link{setup_parallel_execution}()},
\code{\link{standard_error}()},
\code{\link{statistical_mode}()},
\code{\link{thinning}()},
\code{\link{thinning_til_n}()}
}
\concept{utilities}
