% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_evaluation.R
\name{print_evaluation}
\alias{print_evaluation}
\title{Prints cross-validation results}
\usage{
print_evaluation(model)
}
\arguments{
\item{model}{A model resulting from \code{\link[=rf_evaluate]{rf_evaluate()}}.}
}
\value{
A table printed to the standard output.
}
\description{
Prints the results of an spatial cross-validation performed with \code{\link[=rf_evaluate]{rf_evaluate()}}.
}
\examples{

if(interactive()){

data(
  plants_rf,
  plants_xy
)

plants_rf <- rf_evaluate(
  model = plants_rf,
  xy = plants_xy,
  repetitions = 5,
  n.cores = 1
)

print_evaluation(plants_rf)

}

}
\seealso{
\code{\link[=plot_evaluation]{plot_evaluation()}}, \code{\link[=get_evaluation]{get_evaluation()}}

Other model_info: 
\code{\link{get_evaluation}()},
\code{\link{get_importance}()},
\code{\link{get_importance_local}()},
\code{\link{get_moran}()},
\code{\link{get_performance}()},
\code{\link{get_predictions}()},
\code{\link{get_residuals}()},
\code{\link{get_response_curves}()},
\code{\link{get_spatial_predictors}()},
\code{\link{print.rf}()},
\code{\link{print_importance}()},
\code{\link{print_moran}()},
\code{\link{print_performance}()}
}
\concept{model_info}
