% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_importance.R
\name{print_importance}
\alias{print_importance}
\title{Prints variable importance}
\usage{
print_importance(
  model,
  verbose = TRUE
)
}
\arguments{
\item{model}{A model fitted with \link{rf}, \link{rf_repeat}, or \link{rf_spatial}.}

\item{verbose}{Logical, if \code{TRUE}, variable importance is returned. Default: \code{TRUE}}
}
\value{
A table printed to the standard output.
}
\description{
Prints variable importance scores from \link{rf}, \link{rf_repeat}, and \link{rf_spatial} models.
}
\examples{

data(plants_rf)

print_importance(plants_rf)

}
\seealso{
\code{\link[=plot_importance]{plot_importance()}}, \code{\link[=get_importance]{get_importance()}}

Other model_info: 
\code{\link{get_evaluation}()},
\code{\link{get_importance}()},
\code{\link{get_importance_local}()},
\code{\link{get_moran}()},
\code{\link{get_performance}()},
\code{\link{get_predictions}()},
\code{\link{get_residuals}()},
\code{\link{get_response_curves}()},
\code{\link{get_spatial_predictors}()},
\code{\link{print.rf}()},
\code{\link{print_evaluation}()},
\code{\link{print_moran}()},
\code{\link{print_performance}()}
}
\concept{model_info}
