% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgp.R
\name{make_wxg}
\alias{make_wxg}
\title{Calculate the effect of spatially lagged X variables}
\usage{
make_wxg(wx, gamma)
}
\arguments{
\item{wx}{a matrix of spatially lagged x variables.}

\item{gamma}{a vector of coefficients for the spatially lagged x variables. Its length must match the number of columns in wx.}
}
\value{
A numeric vector
}
\description{
This function computes the contribution of spatially lagged X variables based on
provided coefficients. The function takes the spatially lagged variables (\code{wx}, see \code{\link[=make_wx]{make_wx()}})
and multiplies them by their corresponding regression coefficients (\code{gamma}), returning
the predicted influence of the spatial lags. Only spatial lags are considered;
the original X variables are not included in this calculation.
}
\examples{
grid <- make_square_grid(5)
listw <- spdep::nb2listw(spdep::poly2nb(grid))
x <- make_x(25, c(0,1), c(1,4))
wx <- make_wx(x, listw)
gamma <- c(1.75, 0.4)
make_wxg(wx, gamma) 
}
