% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgp.R
\name{sim_ols}
\alias{sim_ols}
\title{Simulate OLS}
\usage{
sim_ols(u, xb)
}
\arguments{
\item{u}{an error vector}

\item{xb}{predicted x values as calculated by \code{make_xb()}}
}
\value{
A numeric vector
}
\description{
Simulate a y variable for an Ordinary Least Squares (OLS) regression.
}
\examples{
u <- make_error(50, method = "normal")
x <- make_x(50)
xb <- make_xb(x, c(1,2))
y <- sim_ols(u, xb)
lm(y ~ x[[1]])
}
\references{
\href{https://pysal.org/spreg/generated/spreg.dgp.dgp_ols.html#spreg.dgp.dgp_ols}{\code{spreg.dgp.dgp_ols}}
}
