% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPCA.R
\name{plotPCA}
\alias{plotPCA}
\title{Perform PCA and Create a Plot of Scores, Loadings, or Biplot}
\usage{
plotPCA(
  data,
  color_var = NULL,
  shape_var = NULL,
  plot_type = c("score", "loadings", "biplot"),
  palette = "Dark2",
  show_labels = TRUE,
  ellipses = FALSE,
  ellipse_var = NULL,
  display_names = TRUE,
  legend_title = NULL,
  return_pca = FALSE,
  output_format = "tiff",
  output_folder = NULL
)
}
\arguments{
\item{data}{A data frame containing numeric variables. Non-numeric columns are ignored.}

\item{color_var}{Optional character. Column name for coloring points by group. Converted to factor internally.}

\item{shape_var}{Optional character. Column name for shaping points by group. Converted to factor internally.}

\item{plot_type}{Character. Type of PCA plot to generate:
\describe{
  \item{`"score"`}{Plot PCA scores (observations).}
  \item{`"loadings"`}{Plot PCA loadings (variables).}
  \item{`"biplot"`}{Combine scores and loadings in a biplot.}
}}

\item{palette}{Character or vector. Color palette for groups:
\describe{
  \item{`"Dark2"`}{Use Dark2 palette from RColorBrewer (requires the package).}
  \item{single color}{A single color repeated for all groups.}
  \item{vector of colors}{Custom vector of colors, recycled to match number of groups.}
}}

\item{show_labels}{Logical. Display labels for points (scores) or variables (loadings). Default is TRUE.}

\item{ellipses}{Logical. Draw confidence ellipses around groups in score/biplot. Grouping logic for ellipses follows this priority:
\itemize{
  \item If \code{ellipse_var} is provided, ellipses are drawn by that variable.
  \item Else, if \code{color_var} is provided, ellipses are drawn by color groups.
  \item Else, if \code{shape_var} is provided, ellipses are drawn by shape groups.
  \item If none are provided, no ellipses are drawn.
}
Default is FALSE.}

\item{ellipse_var}{Optional character. Name of the variable used to group ellipses. Takes precedence over all other grouping variables. Converted to factor internally. Default is NULL.}

\item{display_names}{Logical. Show legend if TRUE. Default is TRUE.}

\item{legend_title}{Optional character. Legend title corresponding to `color_var` or `shape_var`. Default is NULL.}

\item{return_pca}{Logical. If TRUE, return a list with plot and PCA object. Default is FALSE.}

\item{output_format}{Character. File format for saving plots. Examples: `"tiff"`, `"png"`, `"pdf"`. Default is `"tiff"`.}

\item{output_folder}{Character. Path to folder where plots are saved. If NULL (default), returns a ggplot object (or list with plot and PCA if `return_pca = TRUE`). If specified, plot is saved automatically (function returns PCA object only if `return_pca = TRUE`); if `"."`, plot is saved in the working directory.}
}
\value{
A ggplot2 object representing the PCA plot, or a list with `plot` and `pca` if `return_pca = TRUE`.
}
\description{
Computes principal component analysis (PCA) on numeric variables in a dataset
and generates a PC1 vs PC2 visualization (scores, loadings, or biplot).
}
\examples{
plotPCA(
  data = iris,
  color_var = "Species",
  shape_var = "Species",
  plot_type = "biplot",
  palette = "Dark2",
  show_labels = TRUE,
  ellipses = FALSE,
  display_names = TRUE,
  legend_title = "Iris Species"
)

}
