% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviance.R, R/deviance_glm.R
\name{deviance.spmodel}
\alias{deviance.spmodel}
\alias{deviance.splm}
\alias{deviance.spautor}
\alias{deviance.spglm}
\alias{deviance.spgautor}
\title{Fitted model deviance}
\usage{
\method{deviance}{splm}(object, ...)

\method{deviance}{spautor}(object, ...)

\method{deviance}{spglm}(object, ...)

\method{deviance}{spgautor}(object, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}}, \code{\link[=spautor]{spautor()}}, \code{\link[=spglm]{spglm()}}, or \code{\link[=spgautor]{spgautor()}},
where \code{estmethod} is \code{"ml"} or \code{"reml"}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
The deviance.
}
\description{
Returns the deviance of a fitted model object.
}
\details{
For objects estimated using \code{"ml"} or \code{"reml"},
the deviance is twice the difference in log-likelihoods between the
saturated (perfect-fit) model and the fitted model.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
deviance(spmod)
}
