% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{inc}
\alias{inc}
\alias{mult}
\alias{divi}
\title{In-place operations}
\usage{
inc(e1, e2 = 1)

mult(e1, e2 = 2)

divi(e1, e2 = 2)
}
\arguments{
\item{e1}{object, most likely a numeric object}

\item{e2}{the operation value, the value to add, subtract, multiply, divide of.}
}
\value{
No return, directly assign the value back to `e1`
}
\description{
In-place operations like `i += 1`, `i -= 1` is not support in
R. These functions implement these operations in R.
}
\details{
`inc(i)` is the same as `i <- i + 1`.
`inc(i, -1)` is the same as `i <- i - 1`.
`mult(i)` is the same as `i <- i * 2`.
`divi(i)` is the same as `i <- i / 2`.
}
\examples{
i <- 0
inc(i) # add 1
i
inc(i) # add 1
i
inc(i, -1) # minus 1
i
inc(i, -1) # minus 1
i
x <- 1
mult(x) # times 2
x
mult(x) # times 2
x
divi(x) # divide 2
x
divi(x) # divide 2
x
}
\seealso{
If you want [shiny::reactiveVal]  version of these operators,
check [spsComps](https://systempipe.org/sps/funcs/spscomps/reference/). [shiny::reactiveValues]
operation will be the same as normal values.
}
