#' Spurious Correlations datasets
#'
#' A dataset to preserve tylervigen.com correlations.
#'
#' @format A tibbles with 155 observations and 9 variables:
#' \describe{
#'  \item{year}{Year}
#'  \item{var1}{Variable 1}
#'  \item{var2}{Variable 2}
#'  \item{var1_short}{Variable 1 short name}
#'  \item{var2_short}{Variable 2 short name}
#'  \item{var1_unit}{Variable 1 unit}
#'  \item{var2_unit}{Variable 2 unit}
#'  \item{var1_value}{Variable 1 value}
#'  \item{var2_value}{Variable 2 value}
#'  \item{source}{Source}
#' }
#' @source \url{https://web.archive.org/web/20230607181247/https://tylervigen.com/spurious-correlations}
#' 
#' @examples
#' # Drownings by Falling into a Pool
#' # correlates with
#' # Films Nicolas Cage Appeared In
#' d <- spurious_correlations[spurious_correlations$var2_short == "Nicholas Cage", ]
#' cor(d$var1_value, d$var2_value)
"spurious_correlations"
