% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix.R
\name{sqlf_fix}
\alias{sqlf_fix}
\title{Fix a SQL query}
\usage{
sqlf_fix(
  sql = NULL,
  file = NULL,
  dialect = NULL,
  rules = NULL,
  exclude_rules = NULL,
  config = NULL,
  glue = NULL,
  overwrite = FALSE,
  cat = !overwrite
)
}
\arguments{
\item{sql}{A SQL string to fix.}

\item{file}{Path to a SQL file to fix.}

\item{dialect}{SQL dialect (e.g. `"ansi"`, `"bigquery"`, `"postgres"`).}

\item{rules}{Character vector of rule codes to apply.}

\item{exclude_rules}{Character vector of rule codes to skip.}

\item{config}{A [sqlf_config()] object.}

\item{glue}{If `TRUE`, treat `\{var\}` placeholders as `glue::glue_sql`
variables and preserve them in the fixed output. `NULL` (the default)
reads the `glue` setting from the project `.sqlfluff` config file;
`FALSE` explicitly disables glue handling regardless of project config.}

\item{overwrite}{If `TRUE` and `file` was provided, overwrite the file with
fixed SQL. If `FALSE` (default), the fixed SQL is returned without
modifying the file.}

\item{cat}{If `TRUE` (the default when `overwrite` is `FALSE`), print the
fixed SQL to the console with [cat()] for easy copy-paste. The fixed
string is still returned invisibly.}
}
\value{
The fixed SQL string (invisibly when printed via `cat`).
}
\description{
Automatically fixes style and syntax violations in a SQL string or file
using sqlfluff.
}
\section{Common parsing issues}{

sqlfluff cannot fix SQL that fails to parse. When this happens, the
original SQL is returned unchanged and a warning is issued. Common
causes include:

\itemize{
  \item Missing parentheses after IN: use `WHERE x IN (1)` not
    `WHERE x IN 1`.
  \item "IS NOT IN" syntax: use `WHERE x NOT IN (...)` instead of
    `WHERE x IS NOT IN (...)`.
  \item Glue placeholders without `glue = TRUE`: if your SQL contains
    `\{var\}` placeholders from [glue::glue_sql()], pass `glue = TRUE`
    so sqlfluff treats them as template variables rather than syntax errors.
}
}

\examples{
\dontshow{if (reticulate::virtualenv_exists("r-sqlfluffr")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sqlf_fix(sql = "SELECT  a,b from t where x=1\n")
\dontshow{\}) # examplesIf}
}
