# sqlm 0.1.0

* Initial CRAN submission.

## Features

* `lm_sql()` fits OLS linear regression models entirely in-database via a
  single SQL aggregation query.
* Automatic dummy encoding for character and factor predictors with
  `CASE WHEN` SQL generation.
* Interaction terms (`*`, `:`) fully supported, including interactions between
  numeric and categorical variables.
* Dot expansion (`y ~ .`) expands to all non-response columns.
* Formula transforms: `I()`, `log()`, and `sqrt()` translated to SQL
  equivalents (`POWER`, `LN`, `SQRT`).
* Date and datetime predictor support: `Date` and `POSIXct` columns
  automatically converted to numeric in SQL, matching base R's `lm()` behavior.
* Grouped regression via `dplyr::group_by()` computes multiple models in a
  single `GROUP BY` query.
* No-intercept models (`y ~ 0 + x`) handled correctly.
* S7-based result objects with `broom::tidy()` and `broom::glance()` methods.
* `orbital` integration for in-database predictions.
* Cholesky decomposition for matrix inversion with `MASS::ginv()` fallback
  for rank-deficient designs.
