% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExprCommOp.R
\name{ExprCommOp}
\alias{ExprCommOp}
\title{This class represents an SQL logical operator.}
\description{
This class represents an SQL logical operator.

This class represents an SQL logical operator.
}
\details{
Used to generate SQL expressions involving a commutative binary operator like
in "a + 10 + b".
}
\examples{
# To generate "a + 10 + b":
ExprCommOp$new("+", list(ExprField$new("a"), ExprValue$new(10),
                         ExprField$new("b")))

}
\section{Super classes}{
\code{\link[sqlq:Statement]{sqlq::Statement}} -> \code{\link[sqlq:Expr]{sqlq::Expr}} -> \code{\link[sqlq:ExprComp]{sqlq::ExprComp}} -> \code{ExprCommOp}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ExprCommOp-new}{\code{ExprCommOp$new()}}
\item \href{#method-ExprCommOp-add}{\code{ExprCommOp$add()}}
\item \href{#method-ExprCommOp-nb_expr}{\code{ExprCommOp$nb_expr()}}
\item \href{#method-ExprCommOp-getTokens}{\code{ExprCommOp$getTokens()}}
\item \href{#method-ExprCommOp-clone}{\code{ExprCommOp$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="sqlq" data-topic="Statement" data-id="toString"><a href='../../sqlq/html/Statement.html#method-Statement-toString'><code>sqlq::Statement$toString()</code></a></span></li>
<li><span class="pkg-link" data-pkg="sqlq" data-topic="ExprComp" data-id="enableParenthesis"><a href='../../sqlq/html/ExprComp.html#method-ExprComp-enableParenthesis'><code>sqlq::ExprComp$enableParenthesis()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExprCommOp-new"></a>}}
\if{latex}{\out{\hypertarget{method-ExprCommOp-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprCommOp$new(op, expr = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{op}}{The logical operator, as a string.}

\item{\code{expr}}{A list of logical expressions.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExprCommOp-add"></a>}}
\if{latex}{\out{\hypertarget{method-ExprCommOp-add}{}}}
\subsection{Method \code{add()}}{
Add an SQL expression to the logical operator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprCommOp$add(expr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expr}}{A Expr instance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExprCommOp-nb_expr"></a>}}
\if{latex}{\out{\hypertarget{method-ExprCommOp-nb_expr}{}}}
\subsection{Method \code{nb_expr()}}{
Returns the number of expressions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprCommOp$nb_expr()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The number of expressions in this logical operator.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExprCommOp-getTokens"></a>}}
\if{latex}{\out{\hypertarget{method-ExprCommOp-getTokens}{}}}
\subsection{Method \code{getTokens()}}{
Generates the list of tokens representing this statement.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprCommOp$getTokens()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of Token objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExprCommOp-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ExprCommOp-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExprCommOp$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
