% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_tsi.R
\name{id_tsi}
\alias{id_tsi}
\title{Identify time-since-intervention}
\usage{
id_tsi(df, cohort_var, time_var, intervention_var)
}
\arguments{
\item{df}{Data frame containing the variables in the model.}

\item{cohort_var}{Name of the variable in \code{df} that contains cohort
assignments.}

\item{time_var}{Name of the variable in \code{df} that contains time periods.}

\item{intervention_var}{Name of the cohort-level variable in \code{df} that
specifies which values in \code{time_var} correspond to the first
post-intervention time period for each cohort.}
}
\value{
\code{tsi} Object containing a data frame showing time since intervention
for each time period in the data frame for each cohort in the data frame.
}
\description{
\code{id_tsi()} identifies the number of time periods relative to the intervention
for each observation. This information is used for plotting and for
aggregating model coefficients with \code{ave_coeff()}.
}
\examples{
# Generate a tsi object, containing a data frame showing the time since
# intervention (TSI value) for each time period in the data frame for each
# cohort.
id_tsi(hosp,
       cohort_var = "cohort",
       time_var = "yr",
       intervention_var = "intervention_yr")
}
