% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_data.R
\name{prep_data}
\alias{prep_data}
\title{Prepare a data frame to work with sdid() function}
\usage{
prep_data(df, cohort_var, cohort_ref = NULL, time_var, time_ref = NULL)
}
\arguments{
\item{df}{A data frame containing the variables in the model.}

\item{cohort_var}{String specifying the name of the column in \code{df} that
defines the intervention cohorts.}

\item{cohort_ref}{An optional string specifying the value of \code{cohort_var}
to be used as the referent in the model. If not specified, the value is taken
from the first observed value in \code{cohort_var}.}

\item{time_var}{String specifying the name of the column in \code{df} that defines
time periods over the study.}

\item{time_ref}{An optional string specifying the value of \code{time_var} to be
used as the referent in the model.}
}
\value{
data.frame
}
\description{
Prepare a data frame to work with sdid() function
}
\examples{
dta_prepped <- prep_data(hosp,
                         cohort_var = "cohort",
                         cohort_ref = "0",
                         time_var = "yr",
                         time_ref = "2010")
head(dta_prepped)
}
