% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_statis_dual.R
\name{plot.statis.dual.trajectories}
\alias{plot.statis.dual.trajectories}
\title{Plot Variable Trajectories in STATIS DUAL}
\usage{
\method{plot}{statis.dual.trajectories}(
  vars,
  trajectories,
  labels.tables,
  .range = NULL,
  style.line = list(linetype = 2, linewidth = 0.5, color = "orange"),
  point.size = 3,
  base.colors = c("red", "blue", "brown", "darkgreen", "purple", "orange", "cyan4",
    "gold3", "black")
)
}
\arguments{
\item{vars}{Vector of variable names to plot (must match the names in \code{trajectories}).}

\item{trajectories}{List generated by \code{statis.dual()$trajectories}, where each element is a K x 2 matrix.}

\item{labels.tables}{Vector of length K with the names or labels of the tables.}

\item{.range}{List with axis limits: \code{list(x = c(xmin, xmax), y = c(ymin, ymax))}. If \code{NULL}, limits are computed automatically.}

\item{style.line}{List with line style for the trajectories.}

\item{point.size}{Size of the points at each position along the trajectory.}

\item{base.colors}{Vector of base colors to distinguish the variables.}
}
\value{
A \code{ggplot} object showing the trajectories of the selected variables.
}
\description{
Visualizes the evolution of one or more variables across the different tables
in a STATIS DUAL analysis. Each trajectory represents the sequence of positions
of a variable in the compromise space.
}
\examples{
data(Tuis5_95, Tuis5_96, Tuis5_97, Tuis5_98)
labels = c("95","96","97","98")

res <- statis.dual(list(Tuis5_95, Tuis5_96, Tuis5_97, Tuis5_98), labels.tables = labels)

# If you want to select some variables
vars.A <- c("Ph","ST","NO3")
t <- ggplot2::ggtitle(sprintf("Trayectorias (\%s)", paste(vars.A, collapse = ", ")))

plot.statis.dual.trajectories(vars.A, res$trajectories, res$labels.tables) + t

# If you want to select an specific variable
vars.1 <- "Temp"
t <- ggplot2::ggtitle(sprintf("Trajectory (\%s)", vars.1))

plot.statis.dual.trajectories(vars.1, res$trajectories, res$labels.tables) + t

# All variables
t <- ggplot2::ggtitle("Trajectories (all variables)")
plot.statis.dual.trajectories(res$vars.names, res$trajectories, res$labels.tables) + t

}
\seealso{
\code{\link{plot.statis.dual.circle}}, \code{\link{statis.dual}}
}
