% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statis_dual.R
\name{statis.dual}
\alias{statis.dual}
\title{STATIS DUAL Analysis}
\usage{
statis.dual(tables, labels.tables = NULL)
}
\arguments{
\item{tables}{A list of matrices or data frames with the same columns (variables). Each element represents a "table".}

\item{labels.tables}{A vector of length equal to the number of tables, used to name the tables in the results. If \code{NULL}, labels like \code{("T1", "T2", ...)} are auto-generated.}
}
\value{
A list with the following elements:
\item{labels.tables}{Vector with the table labels}
\item{interstructure}{K x 2 matrix with the coordinates of the tables in the interstructure space}
\item{supervariables}{p x 2 matrix with the coordinates of the variables in the compromise}
\item{trajectories}{List of p K x 2 matrices, one per variable, showing its trajectory across the tables}
\item{vars.names}{Names of the variables (common columns)}
\item{S}{Interstructure similarity matrix}
\item{R}{List of R matrices for each table}
\item{Comp}{Compromise matrix (weighted combination of R matrices)}
\item{eigenvalues.compromise}{Eigenvalues of the compromise (inertia per axis)}
\item{eigenvectors.compromise}{Eigenvectors of the compromise}
\item{beta.weights}{Weights of each table in the construction of the compromise}
}
\description{
Implementation of the STATIS DUAL method for the joint analysis of multiple tables
that share the same variables. This approach allows evaluating the common structure
between tables (interstructure), building a compromise (weighted average of structures),
and analyzing the trajectories of variables across the tables.
}
\details{
The STATIS DUAL method allows:
\itemize{
\item Evaluating structural coherence across multiple tables using the interstructure
\item Constructing a representative compromise of the set of tables
\item Analyzing the behavior of the variables across the set (trajectories)
}

Internally, the tables are centered and normalized considering uniform observation weights.
The R matrices capture the internal structure of each table. The interstructure is based on
scalar products between these matrices.
}
\examples{
data(Tuis5_95, Tuis5_96, Tuis5_97, Tuis5_98)
labels = c("95","96","97","98")

res <- statis.dual(list(Tuis5_95, Tuis5_96, Tuis5_97, Tuis5_98), labels.tables = labels)

# How to use res
t <- ggplot2::ggtitle("Correlation (all variables)")
plot.statis.dual.circle(list(res$supervariables), labels = row.names(res$supervariables)) + t

t <- ggplot2::ggtitle("Trajectories (all variables)")
plot.statis.dual.trajectories(res$vars.names, res$trajectories, res$labels.tables) + t

}
\seealso{
\code{\link{plot.statis.dual.circle}}, \code{\link{plot.statis.dual.trajectories}}
}
