% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readFile.R
\name{readFile}
\alias{readFile}
\title{Read and standardize minute-level step data for one participant}
\usage{
readFile(path, time_format = c(), tz = "")
}
\arguments{
\item{path}{Character vector. Path(s) to the file(s) containing timestamp
and step data for one participant. When multiple files are provided,
they are concatenated in the order given.}

\item{time_format}{Character (optional). Explicit timestamp format string
(as used by \code{\link[base]{strptime}}) to override auto-detection
for CSV inputs. If omitted, a set of common formats is tried
automatically. \emph{The time zone is controlled by} \code{tz}.}

\item{tz}{Character (optional). Time zone in which to interpret and emit
timestamps for CSV/AGD inputs (e.g., \code{"Europe/Madrid"}). The default
\code{""} uses the current R session time zone
(\code{Sys.timezone()} / \code{Sys.getenv("TZ")}). The local \emph{clock
time} in the data is preserved; the returned `timestamp` strings include
an explicit ISO-8601 offset (\code{\%z}). Ignored for GGIR \code{RData}
inputs (timestamps are carried through as stored).}
}
\value{
A \code{data.frame} with two columns:
\describe{
  \item{\code{timestamp}}{Character vector of ISO-8601 datetimes
    (\code{"YYYY-MM-DDTHH:MM:SS\%z"}) for CSV/AGD inputs. For GGIR
    \code{RData} inputs, timestamps are carried through as present in
    \code{IMP$metashort} (which may not include an offset).}
  \item{\code{steps}}{Numeric vector of steps per minute. If the source
    data have sub-minute epochs, values are summed to 60-second bins.
    Epochs longer than 60 seconds are not supported and trigger an error.}
}
}
\description{
Reads one or more files for a single participant and returns a clean,
minute-level data frame with two columns: `timestamp` and `steps`.
The function auto-detects common file formats and timestamp layouts,
fixes ActiGraph CSV headers/metadata when present, and aggregates to a
60-second epoch if input data are recorded at sub-minute resolution.

**Supported input formats**
\itemize{
  \item \strong{CSV}: Generic CSVs and ActiGraph exports (header lines
    and delimiters auto-detected; handles date/time split columns).
  \item \strong{AGD}: ActiGraph binary files via \pkg{PhysicalActivity}.
  \item \strong{RData}: GGIR output (\code{IMP$metashort}).
}
}
\details{
\itemize{
  \item \strong{CSV handling:} Detects and skips ActiGraph header lines
    (typically 10), infers the field separator (comma/semicolon), and
    reconstructs a single timestamp when date and time are stored in
    separate columns. If no explicit timestamp column exists (rare
    ActiGraph cases), a timestamp sequence is reconstructed from the
    file metadata (start time + epoch).
  \item \strong{AGD handling:} Reads via
    \code{\link[PhysicalActivity]{readActigraph}}. The recording start time
    and epoch length are obtained from the embedded database and used to
    build a regular timestamp sequence, interpreted in \code{tz}.
  \item \strong{Step column detection:} The step-count column is inferred
    by matching names containing \emph{"step"} or \emph{"value"}; if multiple
    candidates are present, the column with higher variability is chosen.
  \item \strong{Epoch standardization:} If the input epoch is shorter than
    60 seconds, rows are aggregated by summing steps to 1-minute bins.
    Epochs longer than 60 seconds are currently unsupported and result in
    an error.
}
}
\section{Time zones}{

\describe{
  \item{\strong{CSV / AGD inputs:}}{Timestamps are parsed in \code{tz}
    (default: session time zone) and emitted as ISO-8601 with an explicit
    offset. This preserves the local \emph{clock time}. Running the same
    code on machines with different session time zones may change the
    \emph{offset} but not the \emph{clock time} if you pass a fixed
    \code{tz}.}
  \item{\strong{GGIR \code{RData} inputs:}}{Timestamps are returned as
    stored in \code{IMP$metashort}; no conversion is performed.}
}
}

\examples{
\donttest{
# Fitbit CSV (auto-detect format)
fitbit_csv <- system.file("extdata", "testfiles_fitbit",
                          "S001_d1_1min_epoch.csv", package = "stepmetrics")
df1 <- readFile(fitbit_csv)

# ActiGraph AGD (explicitly pin time zone for reproducibility)
agd <- system.file("extdata", "testfiles_agd", "3h30sec.agd", package = "stepmetrics")
df2 <- readFile(agd, tz = "Europe/Madrid")
}

}
\seealso{
\code{\link{step.metrics}}, \code{\link{get_cadence_bands}},
\code{\link[PhysicalActivity]{readActigraph}}
}
