% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{chaco}
\alias{chaco}
\title{Chaco dry rainforest data (2012-2022)}
\format{
A \code{sf} POINT dataset with 2000 observations and 12 fields.
\describe{
\item{id}{An observation identifier}
\item{ndvi}{Normalised Difference Vegetation Index (NDVI)}
\item{tmax}{Maximum temperature (°C)}
\item{pr}{Preciptation}
\item{month}{A continous integer variable from 1 to 120}
\item{year}{The year of observation}
\item{lon}{Longitude in degrees (WGS84)}
\item{lat}{Latitude in degrees (WGS84)}
\item{X}{Easting in metres from the SIRGAS 2000 / Brazil Mercator projection (EPSG:5641)}
\item{Y}{Northing in metres from the SIRGAS 2000 / Brazil Mercator projection (EPSG:5641)}
\item{geometry}{The spatial geometry of the observation in the SIRGAS 2000 / Brazil Mercator projection (EPSG:5641)}
}
}
\source{
Gorelick, N., Hancher, M., Dixon, M., Ilyushchenko, S., Thau, D., & Moore, R. (2017). Google Earth Engine: Planetary-scale geospatial analysis for everyone. Remote Sensing of Environment, 202, 18–27. https://doi.org/10.1016/J.RSE.2017.06.031

Li, M., Cao, S., Zhu, Z., Wang, Z., Myneni, R. B., & Piao, S. (2023). Spatiotemporally consistent global dataset of the GIMMS Normalized Difference Vegetation Index (PKU GIMMS NDVI) from 1982 to 2022. Earth System Science Data, 15(9), 4181–4203. https://doi.org/10.5194/ESSD-15-4181-2023
}
\usage{
chaco
}
\description{
A point dataset of NDVI and climate data. The data are sample of 2000 observations of Normalised Difference Vegetation Index (NDVI) (2012-2022) of the Chaco dry rainforest in South America with some climate data. These are found via Google Earth Engine (Gorelick et al., 2017). The NDVI data is sourced from the PKU GIMMS NDVI v1.2 dataset, which provides NDVI observations at 1/12° spatial resolution at bi-monthly intervals from 1982 to 2022 (Li et al., 2023). The climate data was derived from the TerraClimate dataset (IDAHO_EPSCOR/TERRACLIMATE). Maximum temperature (\code{tmax}) and Precipitation (\code{pr}) were selected and means calculated for each monthly image across all pixels.
}
\examples{
library(sf)
data("chaco")
}
\keyword{datasets}
