% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsample_routine.R
\name{subsample_routine}
\alias{subsample_routine}
\title{Convert a daily record to periodic discrete}
\usage{
subsample_routine(dates, values, day = 15, freq = "month")
}
\arguments{
\item{dates}{A vector of dates of 'Date' class.}

\item{values}{Numeric values. The values must be in correspondence with \code{dates}, meaning the
\emph{i}th element in \code{values} must correspond to the \emph{i}th date in \code{dates}.}

\item{day}{An integer specifying the day of the specified \code{freq}uency. See 'Details'.}

\item{freq}{A character string indicating the frequency of selection. Must be one of "day",
"week", or "month". See 'Details'.}
}
\value{
A data.frame with the following columns:
\tabular{lll}{
\strong{Name} \tab \strong{Type} \tab \strong{Description} \cr
date \tab Date \tab Date \cr
value \tab numeric \tab Input \code{values} \cr
selection_type \tab character \tab Type of randomly selected value "not_selected" (an
observation not selected), "routine" (selected record) \cr
}
}
\description{
#'
Subsample a daily or near-daily data set to one containing infrequent but regularly recurring
records based on a specified frequency. Intended to be used on a (near) daily water quality
record.
}
\examples{
create_plot <- function(df, log_xfrm = "x", xlab, ylab, subtitle) {
  plot(
    df$q[df$selection_type == "not_selected"],
    df$value[df$selection_type == "not_selected"],
    pch = 21, col = "gray",
    xlab = xlab, ylab = ylab,
    main = paste0("Subsampled Daily Data\n", subtitle),
    log = log_xfrm
  )
  points(
    df$q[df$selection_type != "not_selected"],
    df$value[df$selection_type != "not_selected"],
    pch = 16, cex = 1.5,
    col = c(
      "routine" = "#42047E"
    )[df$selection_type[df$selection_type != "not_selected"]]
  )
  legend(
    "topright",
    legend = c("Not Selected", "Routine"),
    col = c("gray", "#42047E"),
    pch = c(21, 16),
    bty = "n"
  )
}

# 15th of each month
sroutine <- subsample_routine(
  dates = streamdat$date, values = streamdat$sc, 
  day = 15, freq = "month"
)
df <- merge(streamdat[, -3], sroutine)
create_plot(
  df, "x", "Discharge (CFS)", 
  "Specific Conductivity (uS/cm)", "Subsampled on 15th of each month"
)

# Every Wednesday
sroutine <- subsample_routine(
  dates = streamdat$date, values = streamdat$sc, 
  day = 4, freq = "week"
)
df <- merge(streamdat[, -3], sroutine)
create_plot(
  df, "x", "Discharge (CFS)", 
  "Specific Conductivity (uS/cm)", "Subsampled on every Wednesday"
)

# Every 60th day
sroutine <- subsample_routine(
  dates = streamdat$date, values = streamdat$sc, 
  day = 60, freq = "day"
)
df <- merge(streamdat[, -3], sroutine)
create_plot(
  df, "x", "Discharge (CFS)", 
  "Specific Conductivity (uS/cm)", "Subsampled every 60th day"
)

}
