% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_table.R
\name{clean_table}
\alias{clean_table}
\title{Standardize missing value display across all gtsummary table types}
\usage{
clean_table(tbl, symbol = "---")
}
\arguments{
\item{tbl}{A gtsummary table object (e.g., from
\code{tbl_summary()}, \code{tbl_svysummary()}, \code{tbl_regression()},
or \code{tbl_strata()})}

\item{symbol}{Character string to replace missing values
with. Default is \code{"---"} (em-dash style). Common
alternatives: \code{"\\u2014"} (em-dash), \code{"\\u2013"}
(en-dash), \code{"--"}, or \code{"N/A"}.}
}
\value{
A gtsummary table object with standardized missing value display
}
\description{
Replaces various missing value representations
with a consistent symbol (default \code{"---"}) so it is
easier to tell actual data from missing or undefined values.

Works with all gtsummary table types, including stacked
tables (\code{tbl_strata}) and survey-weighted summaries
(\code{tbl_svysummary}). Handles tables with or without the
standard \code{var_type} column.
}
\details{
The function uses \code{gtsummary::modify_table_body()} to transform
character columns and replace missing, undefined, and zero-valued
patterns with a consistent symbol. Matched patterns include:
\itemize{
\item Literal \code{NA} and \code{Inf} / \code{-Inf} values
\item Count/percent pairs: \code{"0 (0\%)"}, \code{"0 (NA\%)"}, \code{"0 (NA)"}, \code{"NA (0)"},
\code{"NA (NA)"}
\item Decimal variants: \code{"0.00 (0.00)"}, \code{"0.00\% (0.00)"}, \code{"0\% (0.000)"}
\item Paired values: \code{"NA, NA"}
\item Confidence intervals: \code{"NA (NA, NA)"}, \code{"0\% (0.000) (0\%, 0\%)"},
\code{"0.00 (0.00) (0.00, 0.00)"}, and similar zero-CI patterns
}

Replacing these patterns with a single symbol keeps
the table easier to read.

Note: The function checks for the presence of \code{var_type}
column before applying \code{modify_missing_symbol()}. This
allows it to work with \code{tbl_strata} objects which use
\code{var_type_1}, \code{var_type_2}, etc. instead of \code{var_type}.
}
\examples{
\donttest{
# Basic usage - clean missing values in summary table
demo_trial <- gtsummary::trial |>
  dplyr::mutate(
    age = dplyr::if_else(trt == "Drug B", 0, age),
    marker = dplyr::if_else(trt == "Drug A", NA, marker)
  ) |>
  dplyr::select(trt, age, marker)

demo_trial |>
  gtsummary::tbl_summary(by = trt) |>
  clean_table()

# Used inside extras() automatically
demo_trial |>
  gtsummary::tbl_summary(by = trt) |>
  extras()

# Custom missing symbol
demo_trial |>
  gtsummary::tbl_summary(by = trt) |>
  clean_table(symbol = "???")
}

}
\seealso{
\itemize{
\item \code{gtsummary::modify_table_body()} for general table body modifications
\item \code{extras()} which includes \code{clean_table()} in its styling pipeline
}
}
