% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_tbody_css.R
\name{add_css_tbody}
\alias{add_css_tbody}
\title{Add css to the tbody tag}
\usage{
add_css_tbody(tableHTML, css)
}
\arguments{
\item{tableHTML}{A tableHTML object created by the tableHTML function.}

\item{css}{A list of two elements with the corresponding css. The first element of the list
should be an atomic vector with the style definitions (e.g. background-color). The second
element will be an atomic vector with the same length as the first element, which will 
contain the style definitions' values (e.g. red). Check the examples for more information.}
}
\value{
A tableHTML object.
}
\description{
\code{add_css_tbody} will add css to the tbody tag i.e. to all table apart from the headers and
  second headers.
}
\details{
\code{add_css_thead} will add css to the tbody tag i.e. to all table apart from the headers and
  second headers.
}
\examples{
tableHTML(mtcars) \%>\% 
  add_css_tbody(css = list('background-color', 'lightgray')) 
  
tableHTML(mtcars) \%>\% 
  add_css_tbody(css = list('background-color', 'lightgray')) \%>\%
  add_css_tbody(css = list('background-color', 'lightblue')) 
  
tableHTML(mtcars) \%>\% 
  add_css_tbody(css = list('background-color', 'lightgray')) \%>\%
  add_css_tbody(css = list('text-align', 'center'))
  

}
