% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_excel.R
\name{as_excel}
\alias{as_excel}
\title{as_excel}
\usage{
as_excel(
  tbl,
  workbook = openxlsx::createWorkbook(),
  sheet = "Table",
  start_row = 1,
  start_col = 1,
  merge_rownames = TRUE
)
}
\arguments{
\item{tbl}{table created with tablespan::tablespan}

\item{workbook}{Excel workbook created with openxlsx::createWorkbook()}

\item{sheet}{name of the sheet to which the table should be written to}

\item{start_row}{row at which to start the table}

\item{start_col}{column at which to start the table}

\item{merge_rownames}{should row names with identical entries be merged?}
}
\value{
openxlsx workbook object that can be edited and saved with openxlsx
}
\description{
Write a tablespan table to an excel workbook.
}
\examples{
library(tablespan)
library(dplyr)
data("iris")

tbl <- tablespan(data = iris[iris$Species == "setosa", ],
          formula = Species ~ (Sepal = Sepal.Length + Sepal.Width) +
            (Petal = (Width = Petal.Length) + Petal.Width))

wb <- as_excel(tbl = tbl)

# saveWorkbook(wb, "iris.xlsx")

# The main use case for tablespan is when you already have a summarized table
# that you now want to share using xlsx. The following shows an example using
# the dplyr package:

# First summarize the data:
summarized_table <- mtcars |>
  group_by(cyl, vs) |>
  summarise(N = n(),
            mean_hp = mean(hp),
            sd_hp = sd(hp),
            mean_wt = mean(wt),
            sd_wt = sd(wt))

# Now, we want to create a table, where we show the grouping variables
# as row names and also create spanners for the horse power (hp) and the
# weight (wt) variables:
tbl <- tablespan(data = summarized_table,
          formula = Cylinder:cyl + Engine:vs ~
            N +
            (`Horse Power` = Mean:mean_hp + SD:sd_hp) +
            (`Weight` = Mean:mean_wt + SD:sd_wt),
          title = "Motor Trend Car Road Tests",
          subtitle = "A table created with tablespan",
          footnote = "Data from the infamous mtcars data set.")

wb <- as_excel(tbl = tbl)

# Create the excel table:
# openxlsx::saveWorkbook(wb,
#                        file = "cars.xlsx", overwrite = TRUE)
}
