% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{style_hline}
\alias{style_hline}
\title{style_hline}
\usage{
style_hline(tbl, openxlsx_style)
}
\arguments{
\item{tbl}{tablespan table}

\item{openxlsx_style}{style used when exporting to openxlsx}
}
\value{
the tablespan table with added styles
}
\description{
Set the style used for the horizontal lines of the tablespan table. Currently only
supported for excel export.
}
\details{
- openxlsx_style must be a style object created with openxlsx::createStyle. This style
will then be applied to the horizontal lines
}
\examples{
library(tablespan)
library(dplyr)
data("mtcars")

# We want to report the following table:
summarized_table <- mtcars |>
  group_by(cyl, vs) |>
  summarise(N = n(),
            mean_hp = mean(hp),
            sd_hp = sd(hp),
            mean_wt = mean(wt),
            sd_wt = sd(wt))

# Create a tablespan:
tbl <- tablespan(data = summarized_table,
                 formula = Cylinder:cyl + Engine:vs ~
                   N +
                   (`Horse Power` = Mean:mean_hp + SD:sd_hp) +
                   (`Weight` = Mean:mean_wt + SD:sd_wt),
                 title = "Motor Trend Car Road Tests",
                 subtitle = "A table created with tablespan",
                 footnote = "Data from the infamous mtcars data set.")

wb <- tbl |>
  style_hline(
    openxlsx_style = openxlsx::createStyle(
      border = "Top",
      borderColour = "#928505",
      borderStyle = "thin")) |>
  as_excel()
# save workbook to see effect
}
