% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/occurrence.R
\docType{methods}
\name{index_binomial}
\alias{index_binomial}
\alias{index_binomial-method}
\alias{index_binomial,numeric,numeric-method}
\title{Binomial Co-Occurrence Assessment}
\usage{
index_binomial(x, y, ...)

\S4method{index_binomial}{numeric,numeric}(x, y)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector.}

\item{...}{Currently not used.}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Binomial Co-Occurrence Assessment
}
\details{
This assesses the degree of co-occurrence between taxa/types within a
dataset. The strongest associations are shown by large positive numbers,
the strongest segregations by large negative numbers.

The Binomial co-occurrence assessment approximates a Z-score.
}
\references{
Kintigh, K. (2006). Ceramic Dating and Type Associations. In J. Hantman and
R. Most (eds.), \emph{Managing Archaeological Data: Essays in Honor of
Sylvia W. Gaines}. Anthropological Research Paper, 57. Tempe, AZ: Arizona
State University, p. 17-26.
}
\seealso{
Other beta diversity measures: 
\code{\link{index_brainerd}()},
\code{\link{index_bray}()},
\code{\link{index_cody}()},
\code{\link{index_jaccard}()},
\code{\link{index_morisita}()},
\code{\link{index_routledge}},
\code{\link{index_sorensen}()},
\code{\link{index_whittaker}()},
\code{\link{index_wilson}()}
}
\author{
N. Frerebeau
}
\concept{beta diversity measures}
