% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dive_stats.R
\name{dive_stats}
\alias{dive_stats}
\title{Compute summary statistics for dives or flights}
\usage{
dive_stats(
  P,
  X = NULL,
  dive_cues,
  sampling_rate = NULL,
  prop = 0.85,
  angular = FALSE,
  X_name = NULL,
  na.rm = TRUE
)
}
\arguments{
\item{P}{Depth data. A vector (or one-column matrix), or a tag sensor data list.}

\item{X}{(optional) Another data stream (as a vector (or a one-column matrix) or a tag sensor data list) for which to compute mean and variability. If \code{angular} is TRUE, interpreted as angular data (for example pitch, roll, or heading) and means and variances are computed accordingly.
The unit of measure must be radians (NOT degrees). Currently, \code{X} must be regularly sampled.}

\item{dive_cues}{A two-column data frame or matrix with dive/flight start times in the first column and dive/flight end times in the second. May be obtained from \code{\link{find_dives}}. Units should be seconds since start of tag recording.}

\item{sampling_rate}{(optional and ignored if \code{P} or \code{X} are tag sensor data lists) Sampling rate of \code{P} (and \code{X}, if \code{X} is given). If omitted, then input data must be sensor data lists. If one value is given and both \code{P} and \code{X} are input, they are assumed to have the same sampling rate. If \code{P} and \code{X} have different sampling rates, then this input can have two elements (first for \code{P}, second for \code{X}).}

\item{prop}{The proportion of the maximal excursion to use for defining the "destination" phase of a dive or flight. For example, if \code{prop} is 0.85 (the default), then the destination phase lasts from the first to the last time depth/altitude exceeds 0.85 times the within-dive maximum.}

\item{angular}{Is X angular data? Defaults to FALSE.}

\item{X_name}{A short name to use for X variable in the output data frame. For example, if X is pitch data, use X_name='pitch' to get outputs column names like mean_pitch, etc. Defaults to 'angle' for angular data and 'aux' for non-angular data.}

\item{na.rm}{Logical, default is TRUE. If TRUE, then returned mean values ignore missing values, computing an average over all non-missing observations.}
}
\value{
A data frame with one row for each dive/flight and columns as detailed below. All times are in seconds, and rates in units of x/sec where x is the units of \code{P}.
\itemize{
\item \code{max}  The maximum depth or altitude
\item \code{st} start time of dive (seconds) - from input dive_cues
\item \code{et} end time of dive (seconds) - from input dive_cues
\item \code{dur}  The duration of the excursion
\item \code{dest_st}  The start time of the destination phase in seconds since start of tag recording (which is also the end time of to phase)
\item \code{dest_et}  The end time of the destination phase in seconds since start of tag recording (which is also the start of the from phase).
\item \code{dest_dur}  The duration in seconds of destination phase
\item \code{to_dur}  The duration in seconds of to phase
\item \code{from_dur}  The duration in seconds of from phase
\item \code{mean_angle}  If angular=TRUE and X is input, the mean angle for the entire excursion. Values for each phase are also provided in columns \code{mean_to_angle}, \code{mean_dest_angle}, and \code{mean_from_angle}.
\item \code{angle_var}  If angular=TRUE and X is input, the angular variance for the entire excursion. Values for each phase are also provided individually in columns \code{to_angle_var}, \code{dest_angle_var}, and \code{from_angle_var}.
\item \code{mean_aux}  If angular=FALSE and X is input, the mean value of X for the entire excursion. Values for each phase are also provided in columns \code{mean_to_aux}, \code{mean_dest_aux}, and \code{mean_from_aux}.
\item \code{aux_sd}  If angular=FALSE and X is input, the standard deviation of X for the entire excursion. Values for each phase are also provided individually in columns \code{to_aux_sd}, \code{dest_aux_sd}, and \code{from_aux_sd}.
 }
}
\description{
Given a depth/altitude profile and a series of dive/flight start and end times,
compute summary dive statistics.
}
\details{
In addition to the maximum excursion and duration, \code{dive_stats} divides each excursion into three phases:
"to" (descent for dives, ascent for flights), "from" (ascent for dives, descent for flights), and "destination".
The "destination" (bottom for dives and top for flights)
phase of the excursion is identified using a "proportion of maximum depth/altitude" method,
whereby for example the bottom phase of a dive lasts from the first to the last time the depth exceeds a stated proportion of the maximum depth.
Average vertical velocity is computed for the to and from phases using a simple method: total depth/altitude change divided by total time.
If an angular data variable is also supplied (for example, pitch, roll or heading),
then the circular mean (computed via \code{\link[CircStats]{circ.mean}}) and variance (computed via \code{\link[CircStats]{circ.disp}} and reporting the \code{var} output)
are also computed for each dive phase and the dive as a whole.
}
\seealso{
\code{\link{find_dives}}
}
