% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_absorption.R
\name{mean_absorption}
\alias{mean_absorption}
\title{Calculate the mean absorption in salt water}
\usage{
mean_absorption(freq, r, depth, Ttab = 13)
}
\arguments{
\item{freq}{Specifies the frequency range, freq = c(fmin, fmax) in Hz. For a single frequency, use a scalar value for freq.}

\item{r}{The path (slant) length in metres.}

\item{depth}{The depths covered by the path. This can be a single value for a horizontal path or a two component vector i.e., depth = c(dmax, dmin) for a path that extends between two depths.}

\item{Ttab}{(optional) The temperature (a scalar) in degrees C or specifies a temperature profile Ttab = c(depth, tempr) where depth and tempr are equal-sized column vectors. Default value is an isothermal profile of 13 degrees.}
}
\value{
The mean sound absorption over the path in dB.
}
\description{
This function is used to calculate the mean absorption in salt water over a frequency range.
}
\note{
After Kinsler and Frey pp. 159-160.
}
\examples{
mean_absorption(c(25e3, 60e3), 1000, c(0, 700))
}
