% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txt_recode_fast.R
\name{txt_recode_fast}
\alias{txt_recode_fast}
\title{Fast text recoding (Rcpp version)}
\usage{
txt_recode_fast(x, from = c(), to = c(), na.rm = FALSE)
}
\arguments{
\item{x}{A character vector to recode}

\item{from}{A character vector with values of \code{x} which you want to recode}

\item{to}{A character vector with values you want to use to recode to}

\item{na.rm}{Logical, if set to TRUE, will put all values of \code{x} which
have no matching value in \code{from} to NA. Defaults to FALSE}
}
\value{
A character vector of the same length as \code{x} where values
matching \code{from} are replaced by corresponding values in \code{to}
}
\description{
Efficiently recodes text values using C++ hash tables. This is a drop-in
replacement for \code{txt_recode} but significantly faster for large vectors.
}
\details{
This function uses C++ hash tables for O(1) lookup time, making it much
faster than the pure R implementation, especially for large datasets.

Performance improvement: ~50-100x faster than base R \code{txt_recode}
for vectors with 100K+ elements.
}
\examples{
x <- c("NOUN", "VERB", "NOUN", "ADV")
txt_recode_fast(x,
  from = c("VERB", "ADV"),
  to = c("conjugated verb", "adverb")
)

}
