% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-access.R
\name{get_reccobeats_audio_features}
\alias{get_reccobeats_audio_features}
\title{Reccobeats audio features}
\usage{
get_reccobeats_audio_features(track_id)
}
\arguments{
\item{track_id}{The Spotify ID for a track.}
}
\value{
\itemize{
\item \code{get_reccobeats_audio_features()} returns a
\link[tibble:tibble-package]{tibble} with track audio features, including:
\itemize{
\item \code{danceability}: Suitability for dancing (0.0 to 1.0). Higher values
indicate more rhythmically engaging tracks.
\item \code{energy}: Intensity and liveliness (0.0 to 1.0). Higher values indicate
more energetic tracks.
\item \code{loudness}: Average loudness in decibels (dB). Typically ranges between
-60 and 0 dB.
\item \code{speechiness}: Presence of spoken words (0.0 to 1.0). Values above 0.66
indicate mostly speech.
\item \code{acousticness}: Confidence (0.0 to 1.0) that the track is acoustic.
Higher values indicate more natural sounds.
\item \code{instrumentalness}: Likelihood of no vocals (0.0 to 1.0). Values above
0.5 suggest instrumental tracks.
\item \code{liveness}: Probability of a live audience (0.0 to 1.0). Values above
0.8 strongly suggest a live track.
\item \code{valence}: Emotional tone (0.0 to 1.0). Higher values indicate a
happier mood, lower values a sadder one.
\item \code{tempo}: Estimated tempo in beats per minute (BPM). Typically ranges
between 0 and 250.
\item \code{key}: The key the track is in. Integers map to pitches using standard
Pitch Class notation. If no key was detected, the value is -1.
\item \code{mode}: Mode indicates the modality (major or minor) of a track.
Major is represented by 1 and minor is 0.
\item \code{key_name}: Corresponds directly to the key, but the integer is
converted to the key name using Pitch Class notation (e.g., 0 becomes
\code{C}).
\item \code{mode_name}: Corresponds directly to the mode, but the integer is
converted to the mode name (e.g., 0 becomes \code{minor}).
\item \code{key_mode}: A combination of the \code{key_name} and \code{mode_name} variables
(e.g., \verb{C minor}).
}
}
}
\description{
Access the Reccobeats API to get audio features for tracks.
}
\examples{
\dontshow{if (taylor_examples()) withAutoprint(\{ # examplesIf}
# So High School
get_reccobeats_audio_features(track_id = "7Mts0OfPorF4iwOomvfqn1")
\dontshow{\}) # examplesIf}
}
\seealso{
Other API access: 
\code{\link{get_soundstat_audio_features}()},
\code{\link{get_spotify_track_info}()}
}
\concept{API access}
