test_that("data has expected dimensions", {
  # all songs
  expect_equal(ncol(taylor_all_songs), 26L)
  expect_equal(ncol(taylor_all_songs$lyrics[[1]]), 4L)

  # album songs
  expect_equal(ncol(taylor_album_songs), 26L)
  expect_equal(ncol(taylor_album_songs$lyrics[[1]]), 4L)

  # albums
  expect_equal(ncol(taylor_albums), 5L)

  # surprise songs
  expect_equal(ncol(eras_tour_surprise), 9L)

  albums <-
    unique(taylor_all_songs[
      which(
        (!taylor_all_songs$ep) &
          !is.na(taylor_all_songs$album_name)
      ),
      "album_name"
    ])

  albums <- tolower(albums[[1]])
  albums <- gsub("\\ ", "_", albums)
  albums <- gsub("\\(taylor's_version\\)", "tv", albums)
  albums <- gsub("the_(tortured_poets)_department", "\\1", albums)
  albums <- gsub("the_life_of_a_(showgirl)", "\\1", albums)

  expect_equal(length(albums), length(album_palettes))
  expect_equal(length(albums), length(album_compare))
  expect_equal(length(album_palettes), length(album_compare))
  expect_equal(albums, names(album_palettes))
  expect_equal(albums, names(album_compare))
  expect_equal(names(album_palettes), names(album_compare))
})

test_that("column names match documentation expectation", {
  data_cols <- c(
    "album_name",
    "ep",
    "album_release",
    "track_number",
    "track_name",
    "artist",
    "featuring",
    "bonus_track",
    "promotional_release",
    "single_release",
    "track_release",
    "danceability",
    "energy",
    "loudness",
    "acousticness",
    "instrumentalness",
    "valence",
    "tempo",
    "duration_ms",
    "explicit",
    "key",
    "mode",
    "key_name",
    "mode_name",
    "key_mode",
    "lyrics"
  )

  # all songs
  expect_equal(colnames(taylor_all_songs), data_cols)
  expect_equal(
    colnames(taylor_all_songs$lyrics[[1]]),
    c("line", "lyric", "element", "element_artist")
  )

  # album songs
  expect_equal(colnames(taylor_album_songs), data_cols)
  expect_equal(
    colnames(taylor_album_songs$lyrics[[1]]),
    c("line", "lyric", "element", "element_artist")
  )

  # albums
  expect_equal(
    colnames(taylor_albums),
    c("album_name", "ep", "album_release", "metacritic_score", "user_score")
  )

  # surprise songs
  expect_equal(
    colnames(eras_tour_surprise),
    c(
      "leg",
      "date",
      "city",
      "night",
      "dress",
      "instrument",
      "song",
      "mashup",
      "guest"
    )
  )
})

test_that("non-TV versions are excluded when possible", {
  exclude_albums <- c(
    taylor_albums$album_name[which(taylor_albums$ep)]
  )

  expect_false(any(exclude_albums %in% taylor_album_songs$album_name))
})

test_that("surprise songs are the correct version", {
  songs <- eras_tour_surprise$song
  mashups <- eras_tour_surprise$mashup[which(!is.na(eras_tour_surprise$mashup))]
  mashups <- unlist(strsplit(mashups, split = "; "))

  expect_true(all(
    c(songs, mashups) %in%
      c(
        taylor_all_songs$track_name,
        "Thinking Out Loud",
        "Espresso",
        "Please Please Please",
        "I Love You, I'm Sorry"
      )
  ))

  no_tv_songs <- c(songs, mashups)[grep(
    "Taylor's Version",
    eras_tour_surprise$song,
    invert = TRUE
  )]
  expect_false(any(
    paste(no_tv_songs, "(Taylor's Version)") %in%
      taylor_all_songs$track_name
  ))
})
