% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discr_test.R
\name{discr_test}
\alias{discr_test}
\title{Testing item discriminations}
\usage{
discr_test(data)
}
\arguments{
\item{data}{Data matrix.}
}
\value{
A list of class \code{tcl} of test statistics, degrees of freedom, and p-values.
 \item{test}{A numeric vector of Wald (W), likelihood ratio (LR), Rao score (RS), and gradient (GR)statistics.}
 \item{df}{A numeric vector of corresponding degrees of freedom.}
 \item{pvalue}{A vector of corresponding p-values.}
 \item{data}{Data matrix.}
 \item{call}{The matched call.}
}
\description{
Computes Wald (W), likelihood ratio (LR), Rao score (RS) and gradient (GR) test of
 hypothesis of equal item discriminations against the
  alternative that at least one item discriminates differently (only for binary data).
}
\details{
The tests are based on the following model suggested in Draxler, Kurz, Gürer, and Nolte (2024)

\deqn{ \text{logit} \big( E(Y) \big ) = \tau + \alpha + \delta (r - 1), }

where \eqn{E(Y)} ist the expected value of a binary response (of a person to an item),
\eqn{r = 1, \dots, k - 1} is the person score, i.e., number of correct responses of that person
when responding to \eqn{k} items, \eqn{\tau} is the respective person parameter and \eqn{\alpha} and
\eqn{\delta} are two parameters referring to the respective item. The parameter \eqn{\alpha}
represents a baseline, i.e., the easiness or attractiveness of the respective item in person score
group \eqn{r = 1}. The parameter \eqn{\delta} denotes the constant change of the attractiveness of that
item between successive person score groups. Thus, the model assumes a linear effect of the person
score \eqn{r} on the logit of the probability of a correct response.

The four test statistics are derived from a conditional likelihood function in which the
\eqn{\tau} parameters are eliminated by conditioning on the observed person scores.
The hypothesis to be tested is formally given by setting all \eqn{\delta} parameters equal to \eqn{0}.
The alternative assumes that at least one \eqn{\delta} parameter is not equal to \eqn{0}.
}
\examples{
\dontrun{
##### Dataset PISA Mathematics data.pisaMath {sirt} #####

library(sirt)
data(data.pisaMath)
y <- data.pisaMath$data[, grep(names(data.pisaMath$data), pattern = "M" )]

res <- discr_test(data = y)
# $test
#      W     LR     RS     GR
# 72.470 73.032 76.725 73.430
#
# $df
# W LR RS  GR
# 10 10 10 10
#
# $pvalue
#       W        LR        RS         GR
# "< 0.001" "< 0.001" "< 0.001" "< 0.001"
#
# $call
# discr_test(X = y)

}
}
\references{
{
Draxler, C., Kurz, A., Guerer, C., & Nolte, J. P. (2024). An Improved Inferential Procedure to Evaluate Item Discriminations
in a Conditional Maximum Likelihood Framework. \emph{Journal of Educational and Behavioral Statistics}, 49(3), 403-430.

 }
}
\seealso{
\code{\link{invar_test}}, \code{\link{change_test}}, and \code{\link{LLTM_test}}.
}
\keyword{htest}
