% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invar_test.R
\name{invar_test}
\alias{invar_test}
\title{Test of invariance of item parameters between two groups.}
\usage{
invar_test(data, splitcr = "median", model = "RM")
}
\arguments{
\item{data}{Data matrix.}

\item{splitcr}{Split criterion which is either "mean", "median" or a numeric vector x.
\describe{
 \item{"mean"}{Corresponds to division of the sample according to the mean of the person score.}
 \item{"median"}{Corresponds to division of the sample according to the median of the person score.}
  \item{x}{Has length equal to number of persons and contains zeros and ones. It indicates group membership for every person.}
  }}

\item{model}{RM, PCM, RSM}
}
\value{
A list of class \code{tcl} of test statistics, degrees of freedom, and p-values.
 \item{test}{A numeric vector of Wald (W), likelihood ratio (LR), Rao score (RS), and gradient (GR) test statistics.}
 \item{df}{A numeric vector of corresponding degrees of freedom.}
 \item{pvalue}{A vector of corresponding p-values.}
 \item{deleted_items}{A list with numeric vectors of item numbers that were excluded before computing corresponding test statistics.}
 \item{sample_size_informative}{Informative sample size of data omitting persons with min. and max score.}
 \item{effect}{Numeric value for each test representing the effect size. A real number between 0 and 1, interpreted as
 a proportion of pseudo -variance between the two groups of persons considered.}
 \item{data}{Data matrix.}
 \item{call}{The matched call.}
}
\description{
Computes Wald (W), likelihood ratio (LR), Rao score (RS) and gradient (GR) test statistics
  for hypothesis of equality of item parameters between two groups of persons against a two-sided
 alternative that at least one item parameter differs between the two groups.
}
\details{
Note that items are excluded for the computation of GR, LR, and W due to inappropriate
 response patterns within subgroups and for computation of RS due to inappropriate
 response patterns in the total data. If the model is identified from the total data but not from one
 or both subgroups only RS will be computed. If the model is not identified from the total data,
 no test statistic is computable.
}
\examples{
\dontrun{
##### Rasch Model #####
y <- eRm::sim.rasch(persons = rnorm(400), c(0,-3,-2,-1,0,1,2,3))
x <- c(rep(1,200),rep(0,200))

res <- invar_test(data = y, splitcr = x, model = "RM")

res$test # test statistics
res$df # degrees of freedoms
res$pvalue # p-values
res$deleted_items # excluded items

$test
    W     LR     RS     GR
14.972 14.083 13.678 12.492

$df
W LR RS GR
7  7  7  7

$pvalue
   W      LR      RS     GR
"0.073" "0.050" "0.057" "0.043"

$deleted_items
 $deleted_items$GR
 [1] "none"

 $deleted_items$LR
 [1] "none"

 $deleted_items$RS
 [1] "none"

 $deleted_items$W
 [1] "none"

$sample_size_informative
[1] 395

$effect
    W    LR    RS    GR
0.014 0.014 0.014 0.014

$call
invar_test(X = y, splitcr = x, model = "RM")

}
}
\references{
{
Draxler, C. (2010). Sample Size Determination for Rasch Model Tests. Psychometrika, 75(4), 708–724.

Draxler, C., & Alexandrowicz, R. W. (2015). Sample Size Determination Within the Scope of Conditional Maximum Likelihood Estimation
with Special Focus on Testing the Rasch Model. Psychometrika, 80(4), 897–919.

Draxler, C., Kurz, A., & Lemonte, A. J. (2022). The gradient test and its finite sample size properties in a conditional
maximum likelihood and psychometric modeling context. Communications in Statistics-Simulation and Computation, 51(6), 3185-3203.

Glas, C. A. W., & Verhelst, N. D. (1995a). Testing the Rasch Model. In G. H. Fischer & I. W. Molenaar (Eds.),
Rasch Models: Foundations, Recent Developments, and Applications (pp. 69–95). New York: Springer.

Glas, C. A. W., & Verhelst, N. D. (1995b). Tests of Fit for Polytomous Rasch Models. In G. H. Fischer & I. W. Molenaar (Eds.),
Rasch Models: Foundations, Recent Developments, and Applications (pp. 325-352). New York: Springer.

 }
}
\seealso{
\code{\link{change_test}}, and \code{\link{LLTM_test}}.
}
\keyword{htest}
