% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-exclusive.R
\name{exclusivity-expectations}
\alias{exclusivity-expectations}
\alias{expect_exclusive}
\title{Expectations: exclusivity}
\usage{
expect_exclusive(vars, var_set, exc_val = 1, flt = TRUE, data = get_testdata())
}
\arguments{
\item{vars}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> A set of columns to
test.}

\item{var_set}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> The full set of
columns to check against. This should include all columns specified in the
\code{vars} argument.}

\item{exc_val}{The value that flags a variable as "selected" (default: \code{1})}

\item{flt}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> A filter specifying
a subset of the data frame to test.}

\item{data}{A data frame to test. The \link[=global-data]{global test data} is used
by default.}
}
\value{
\verb{expect_*()} functions are mainly called for their side effects. The
expectation signals its result (e.g. "success", "failure"), which is logged
by the current \link[testthat:Reporter]{test reporter}. In a non-testing
context the expectation will raise an error with class
\code{expectation_failure} if it fails.
}
\description{
\code{expect_exclusive} tests that \code{vars} are exclusive - that, if any one of
\code{vars} is set to \code{exc_val}, no other column in \code{vars} or \code{var_set} is also
set to \code{exc_val}.
}
\details{
This expectation is designed to check exclusivity in survey multiple response
sets, where one response is only valid on its own.

See the example data set below:
\itemize{
\item No record should have \code{q10_98}, "None of the above", selected while also
having any other response selected, so we refer to this as an "exclusive"
response.
\item \code{expect_exclusive()} checks whether \code{q10_98} "None of the above" or
\code{q10_99} "Don't know", the exclusive responses, have been selected alongside
any other \verb{q10_*} response.
\item The expectation fails, since the first record has both \code{q10_1} and
\code{q10_98} selected.
}
}
\examples{

my_q_block <- data.frame(
  resp_id = 1:5, # Unique to respondent
  q10_1  = c(1, 1, 0, 0, 0),
  q10_2  = c(0, 1, 0, 0, 0),
  q10_3  = c(0, 0, 1, 0, 0),
  q10_98 = c(1, 0, 0, 1, 0), # None of the above
  q10_99 = c(0, 0, 0, 0, 1)  # Item not answered
)

# Make sure that if "None of the above" and "Item skipped" are selected
# none of the other question options are selected:
try(
expect_exclusive(
  c(q10_98, q10_99),
  starts_with("q10_"),
  data = my_q_block
)
)
}
\seealso{
Other data expectations: 
\code{\link{conditional-expectations}},
\code{\link{datacomp-expectations}},
\code{\link{date-expectations}},
\code{\link{expect_depends}()},
\code{\link{generic-expectations}},
\code{\link{label-expectations}},
\code{\link{pattern-expectations}},
\code{\link{proportion-expectations}},
\code{\link{text-expectations}},
\code{\link{uniqueness-expectations}},
\code{\link{value-expectations}}
}
\concept{data expectations}
