% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagpol.R
\name{factors}
\alias{factors}
\alias{factors.lagpol}
\title{Lag polynomial factorization}
\usage{
factors(lp, ...)

\method{factors}{lagpol}(lp, full = TRUE, tol = 1e-05, expand = FALSE, ...)
}
\arguments{
\item{lp}{an object of class \code{lagpol}.}

\item{...}{additional arguments.}

\item{full}{logical value. If TRUE, the lag polynomial is completely
factored. Otherwise, it is factored separating positive real roots from the
others.}

\item{tol}{tolerance for nonzero coefficients.}

\item{expand}{logical value to indicate whether or not the factored lag
polynomial must be expanded.}
}
\value{
\code{factors} returns a list with the simplifying factors of the lag
  polynomial or the expanded polynomial.
}
\description{
\code{factors} extracts the simplifying factors of a polynomial in the lag
operator by replacing, if needed, its approximate unit or real roots to exact
unit or real roots.
}
\examples{
factors( as.lagpol(c(1, rep(0, 11), -1)) )

}
