% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf.R
\name{irf}
\alias{irf}
\title{Impulse response function}
\usage{
irf(tf, lag.max = 10, cum = FALSE, plot = TRUE)
}
\arguments{
\item{tf}{An object of class "tf".}

\item{lag.max}{Integer. Maximum number of lags to compute (default 10).}

\item{cum}{Logical. If TRUE computes step response function (cumulative), 
if FALSE computes impulse response function (default FALSE).}

\item{plot}{Logical. If TRUE creates a plot, if FALSE returns values only (default TRUE).}
}
\value{
If \code{plot = FALSE}, a named numeric vector with IRF/SRF values.
  If \code{plot = TRUE}, creates a plot and returns nothing (invisibly).
}
\description{
Computes and plots the impulse response function (IRF) or step response 
function (SRF) of a transfer function.
}
\examples{
# Create transfer function
x <- rep(0, 100); x[50] <- 1
tfx <- tf(x, w0 = 0.8, ar = "(1 - 0.5B)")

# Plot impulse response function
irf(tfx, lag.max = 15)

# Get step response values without plot
srf_values <- irf(tfx, lag.max = 10, cum = TRUE, plot = FALSE)

}
