% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm.R
\name{kf}
\alias{kf}
\title{Kalman filter for SS models}
\usage{
kf(mdl, z = NULL, x0 = NULL, P0 = NULL, filtered = FALSE, ...)
}
\arguments{
\item{mdl}{an object of class \code{ssm}.}

\item{z}{time series to be filtered when it differs from the model series.}

\item{x0}{initial state vector.}

\item{P0}{covariance matrix of x1.}

\item{filtered}{logical. If TRUE, the filtered states x_\{t|t\} and their
covariance matrices P_\{t|t\} are returned. Otherwise, the forecasted states 
x_\{t|t-1\} and thier covariance matrices P_\{t|t-1\} are returned.}

\item{...}{additional arguments.}
}
\value{
A list with the innovations, the conditional states and their
  covariance matrices.
}
\description{
\code{kf} computes the innovations and the conditional states with the Kalman
filter algorithm.
}
