% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sankey.R
\name{geom_sankey}
\alias{geom_sankey}
\title{geom_sankey}
\usage{
geom_sankey(
  mapping = NULL,
  data = NULL,
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  space = NULL,
  type = "sankey",
  width = 0.1,
  smooth = 8,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Provide you own mapping. Both x and y need to be numeric.}

\item{data}{Provide you own data.}

\item{position}{Change position.}

\item{na.rm}{Remove missing values.}

\item{show.legend}{Show legend in plot.}

\item{space}{Space between nodes in the y-direction.}

\item{type}{Either `sankey` or `alluvial`.}

\item{width}{Width of nodes.}

\item{smooth}{How much smooth should the curve have? More means steeper curve.}

\item{inherit.aes}{Should the geom inherit aesthetics.}

\item{...}{Other arguments to be passed to the geom.}
}
\value{
A ggplot layer.
}
\description{
Creates a sankey plot which visualize flows between nodes.
Each observation needs to have a `x` aesthetic as well as a `next_x` column which declares where that observation should flow.
Also each observation should have a `node` and a `next_node` aesthetic which provide information about which group in the y-direction.
By default each row of the data frame is counted to calculate the size of flows. A manual flow value can be added with the `value` aesthetic.
}
\section{Aesthetics}{

geom_sankey understand the following aesthetics (required aesthetics are in
bold):

- **x0**
- **y0**
- **a**
- **b**
- **angle**
- m1
- m2
- color
- fill
- size
- linetype
- alpha
- lineend
}

\examples{
dat <- data.frame(
  Group = c("A", "A", "B", "B", "C"),
  Type = c("X", "Y", "X", "Y", "X")
)
long <- make_long(dat, Group, Type)
ggplot2::ggplot(
  long,
  ggplot2::aes(
    x = x,
    next_x = next_x,
    node = node,
    next_node = next_node,
    fill = node
  )
) +
  geom_sankey() +
  theme_sankey()
}
