% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_tableGen_utils.R
\name{prep_bds}
\alias{prep_bds}
\title{Combine BDS Data Frames}
\usage{
prep_bds(datafile, ADSL)
}
\arguments{
\item{datafile}{list of ADaM-ish data frames}

\item{ADSL}{A data frame which contains the ADSL data}
}
\value{
A data frame containing the BDS data bound by rows.
}
\description{
A function to combine all BDS data frames into one large data set.
}
\examples{
if(interactive()) {
  datalist <- list(ADSL = tidyCDISC::adsl, ADVS = tidyCDISC::advs, 
                   ADAE = tidyCDISC::adae, ADLBC = tidyCDISC::adlbc)
                 
  pre_adsl <- prep_adsl(datalist$ADSL, input_recipe = 'NONE')

  prep_bds(datalist, ADSL = pre_adsl$data)
}
}
\keyword{tabGen_repro}
