% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variant_filtering.R
\name{filter_variants}
\alias{filter_variants}
\title{Filter variants based on frequency and depth}
\usage{
filter_variants(tidy_var, maf = 0, ad = 0, invert = FALSE)
}
\arguments{
\item{tidy_var}{Dataframe or tibble with tidy variants.}

\item{maf}{Miminum variant frequency. For each sample, variants with a
proportion of number of reads across all variants > maf are retained.}

\item{ad}{Allele depth. Minimum number of reads supporting a variant.
Variants with ad > 3 are retained.}

\item{invert}{FALSE (default) returns variants passing filters; TRUE inverts
the selection.}
}
\value{
Tidy tibble with filtered variants.

dataframe with filtered variants/alleles. Variants are named so
column names in df are "locus", "sample", "sequence", "reads", "allele".
}
\description{
Filter variants based on frequency and depth
}
\examples{
data("variants")
filter_variants(variants, ad = 100, maf = 0.2)
}
