% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{allstations}
\alias{allstations}
\title{All Canadian stations}
\format{
A tibble with 5 variables:
\itemize{
\item \strong{STATION_NUMBER}: Unique 7 digit Water Survey of Canada station number
\item \strong{STATION_NAME}: Official name for station identification
\item \strong{PROV_TERR_STATE_LOC}: The province, territory or state in which the station is located
\item \strong{HYD_STATUS}: Current status of discharge or level monitoring in the hydrometric network
\item \strong{REAL_TIME}: Logical. Indicates if a station has the capacity to deliver data in
real-time or near real-time
\item \strong{LATITUDE}: North-South Coordinates of the gauging station in decimal degrees
\item \strong{LONGITUDE}: East-West Coordinates of the gauging station in decimal degrees
\item \strong{station_tz}: Timezone of station calculated using the lutz package based on LAT/LONG of stations
\item \strong{standard_offset}: Offset from UTC of local standard time
}
}
\source{
HYDAT, Meteorological Service of Canada datamart
}
\usage{
allstations
}
\description{
A shorthand to avoid having always call \code{hy_stations} or \code{realtime_stations}.
Populated by both realtime and historical data from HYDAT.
}
\keyword{datasets}
