% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_write.R
\name{write_laslogs}
\alias{write_laslogs}
\title{Write LAS logs to CSV and/or Parquet}
\usage{
write_laslogs(data, out_dir, prefix = "laslogs", csv = TRUE, parquet = TRUE)
}
\arguments{
\item{data}{Tibble returned by pull_laslogs()}

\item{out_dir}{Output directory}

\item{prefix}{File prefix (no extension)}

\item{csv}{Write CSV file?}

\item{parquet}{Write Parquet file? (requires arrow)}
}
\value{
Invisibly returns output paths
}
\description{
Write LAS logs to CSV and/or Parquet
}
\examples{
out_dir <- tempdir()
df <- data.frame(api = "1111111111", depth = c(1000, 1001), GR = c(80, 82))
paths <- write_laslogs(df, out_dir = out_dir, prefix = "demo", csv = TRUE, parquet = FALSE)
paths
}
