% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supervised-trees.R
\name{tl_fit_boost}
\alias{tl_fit_boost}
\title{Fit a gradient boosting model}
\usage{
tl_fit_boost(
  data,
  formula,
  is_classification = FALSE,
  n.trees = 100,
  interaction.depth = 3,
  shrinkage = 0.1,
  n.minobsinnode = 10,
  cv.folds = 0,
  ...
)
}
\arguments{
\item{data}{A data frame containing the training data}

\item{formula}{A formula specifying the model}

\item{is_classification}{Logical indicating if this is a classification problem}

\item{n.trees}{Number of trees (default: 100)}

\item{interaction.depth}{Depth of interactions (default: 3)}

\item{shrinkage}{Learning rate (default: 0.1)}

\item{n.minobsinnode}{Minimum number of observations in terminal nodes (default: 10)}

\item{cv.folds}{Number of cross-validation folds (default: 0, no CV)}

\item{...}{Additional arguments to pass to gbm()}
}
\value{
A fitted gradient boosting model
}
\description{
Fit a gradient boosting model
}
\keyword{internal}
