% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{tl_stratified_models}
\alias{tl_stratified_models}
\title{Stratified Features via Clustering}
\usage{
tl_stratified_models(
  data,
  formula,
  cluster_method = "kmeans",
  k = 3,
  supervised_method = "linear",
  ...
)
}
\arguments{
\item{data}{A data frame}

\item{formula}{Model formula}

\item{cluster_method}{Clustering method}

\item{k}{Number of clusters}

\item{supervised_method}{Supervised learning method}

\item{...}{Additional arguments}
}
\value{
A list of models (one per cluster) plus cluster assignments
}
\description{
Create cluster-specific supervised models for heterogeneous data
}
\examples{
\donttest{
models <- tl_stratified_models(mtcars, mpg ~ ., cluster_method = "kmeans",
                                k = 3, supervised_method = "linear")
}
}
