% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extrema.R
\name{extrema-functions}
\alias{extrema-functions}
\alias{min}
\alias{max}
\alias{range}
\alias{pmax}
\alias{pmin}
\title{NA-aware Extrema Functions}
\usage{
min(..., na.rm = TRUE, all_na = NULL)

max(..., na.rm = TRUE, all_na = NULL)

range(..., na.rm = TRUE, all_na = NULL, finite = FALSE)

pmax(..., na.rm = TRUE, all_na = NULL)

pmin(..., na.rm = TRUE, all_na = NULL)
}
\arguments{
\item{...}{Numeric or character arguments.}

\item{na.rm}{Logical. Should missing values be removed? Default \code{TRUE}.}

\item{all_na}{Character. What to do when all values are NA:
\code{"error"} (default) throws an error, \code{"base"} returns what base R does
with \code{na.rm = TRUE} (e.g., \code{Inf} for \code{min()}, \code{-Inf} for \code{max()}),
\code{"na"} returns \code{NA}. If \code{NULL}, uses \code{getOption("tidyna.all_na", "error")}.}

\item{finite}{Logical. If \code{TRUE}, removes all non-finite values (NA, NaN,
Inf, -Inf). Only applies to \code{range()}. Default \code{FALSE}.}
}
\value{
For \code{min()} and \code{max()}, a length-one vector. For \code{range()}, a
length-two vector containing the minimum and maximum. For \code{pmax()} and
\code{pmin()}, a vector of length equal to the longest input.
}
\description{
Drop-in replacements for \code{min()}, \code{max()}, \code{range()}, \code{pmax()}, and \code{pmin()}
that default to \code{na.rm = TRUE}.
}
\examples{
x <- c(1, NA, 5, 3)
min(x)
max(x)
range(x)

# Multiple arguments
min(c(5, NA), c(1, 2))

# Parallel max/min
pmax(c(1, 5, 3), c(2, 1, 4))
pmin(c(1, NA, 3), c(NA, NA, 1))

# range with infinite values
y <- c(1, Inf, 3, -Inf)
range(y)
range(y, finite = TRUE)

}
