% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_gtfs}
\alias{read_gtfs}
\title{Read and validate GTFS files}
\usage{
read_gtfs(path, files = NULL, quiet = TRUE, ...)
}
\arguments{
\item{path}{The path to a GTFS \code{.zip} file.}

\item{files}{A character vector containing the text files to be validated against the GTFS
specification without the file extension (\code{txt} or \code{geojson}). If \code{NULL} (the default),
all existing files are read.}

\item{quiet}{Whether to hide log messages and progress bars (defaults to TRUE).}

\item{...}{Can be used to pass on arguments to \code{\link[gtfsio:import_gtfs]{gtfsio::import_gtfs()}}. The parameters
\code{files} and \code{quiet} are passed on by default.}
}
\value{
A tidygtfs object: a list of tibbles in which each entry represents a GTFS text
file. Additional tables are stored in the \code{.} sublist.
}
\description{
Reads a GTFS feed from either a local \code{.zip} file or an URL and validates them against
GTFS specifications.
}
\note{
\strong{Limitations:} \code{read_gtfs()} does not support downloading GTFS files from URLs that require
authentication. If you need to read a feed behind
authentication, first download the feed to a local file and then pass the local path to
\code{read_gtfs()}.
}
\examples{
\dontrun{
local_gtfs_path <- system.file("extdata", "nyc_subway.zip", package = "tidytransit")
gtfs <- read_gtfs(local_gtfs_path)
summary(gtfs)

gtfs <- read_gtfs(local_gtfs_path, files = c("trips", "stop_times"))
names(gtfs)
}
}
\seealso{
\code{\link[=validate_gtfs]{validate_gtfs()}}, \code{\link[=write_gtfs]{write_gtfs()}}
}
